% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ACPcalculator.R
\name{ACP.calculator}
\alias{ACP.calculator}
\title{Antecedental Rainfall Accumulation calculator for the VI Complete Time Series}
\usage{
ACP.calculator(CTSR.VI, ACP.table)
}
\arguments{
\item{CTSR.VI}{Complete Monthly Time Series of Vegetation Index values.
An object of class \code{'ts'} object without NA's.}

\item{ACP.table}{A table of every combination of offset period and accumulation period.
ACP.table can be calculated using the \code{\link{rainfall.accumulator}}.}
}
\value{
A list containing:

\bold{summary}
       a Matrix containing "slope", "intercept", "p.value", "R^2.Value", "Break.Height", "Slope.Change"
       of the \code{\link[stats]{lm}} between Antecedental Rainfall Accumulation (CTSR.RF) and the CTSR.VI

\bold{CTSR.precip}
       see CTSR.RF in \code{\link{TSSRESTREND}} for description
}
\description{
Takes the Complete Time Series Vegetation Index and a table of every possible accumulation period and offset
period.  A OLS is calculated \code{\link{lm}} for every combination of VI ~ rainfall.  This Function preferences those results where
slope>0 (increase in rainfall causes an increase in vegetation), returning the rainfall accumulation that has the highest R-squared
and a positive slope. If no combinations produce a positive slope then the one with the highest Rsquared is returned.
}
\examples{
#Find the data
vi.path <- system.file("extdata", "rabbitVI.csv", package = "TSS.RESTREND", mustWork = TRUE)
in.VI <- read.csv(vi.path)
CTSR.VI <- ts(in.VI, start=c(1982, 1), end=c(2013,12), frequency = 12)
data(rabbitACPtable)
ACPres <- ACP.calculator(CTSR.VI, rabbitACPtable)
print(ACPres$summary)
}

