% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nondata_adaptive_repr.R
\name{repr_dwt}
\alias{repr_dwt}
\title{DWT representation}
\usage{
repr_dwt(x, level = 4, filter = "d4")
}
\arguments{
\item{x}{the numeric vector (time series)}

\item{level}{the level of DWT transformation (default is 4)}

\item{filter}{the filter name (default is "d6").
Can be: "haar", "d4", "d6", ..., "d20", "la8", "la10", ..., "la20", "bl14", "bl18", "bl20",
 "c6", "c12", ..., "c30". See more info at \code{\link[wavelets]{wt.filter}}.}
}
\value{
the numeric vector of DWT coefficients
}
\description{
The \code{repr_dwt} computes DWT (Discrete Wavelet Transform) representation (coefficients) from a time series.
}
\details{
This function extracts DWT coefficients.
You can use various wavelet filters, see all of them here \code{\link[wavelets]{wt.filter}}.
The number of extracted coefficients depends on the \code{level} selected.
The final representation has length equal to floor(n / 2^{level}), where n is a length of original time series.
}
\examples{
# Interpretation: DWT with Daubechies filter of length 4 and
# 3rd level of DWT coefficients extracted.
repr_dwt(rnorm(50), filter = "d4", level = 3)

}
\references{
Laurinec P, Lucka M (2016)
Comparison of representations of time series for clustering smart meter data.
In: Lecture Notes in Engineering and Computer Science: Proceedings of The World Congress on Engineering and Computer Science 2016, pp 458-463
}
\seealso{
\code{\link[TSrepr]{repr_dft}, \link[TSrepr]{repr_dct}, \link[wavelets]{dwt}}
}
\author{
Peter Laurinec, <tsreprpackage@gmail.com>
}
