% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Trees.R
\docType{class}
\name{tprTrees-class}
\alias{tprTrees-class}
\alias{[,tprTrees,ANY,ANY,ANY-method}
\alias{[,tprTrees-method}
\alias{length,tprTrees-method}
\alias{show,tprTrees-method}
\title{An S4 class to represent one or multiple trees.}
\usage{
\S4method{[}{tprTrees,ANY,ANY,ANY}(x, i, j, ..., drop = FALSE)

\S4method{length}{tprTrees}(x)

\S4method{show}{tprTrees}(object)
}
\arguments{
\item{x}{object of class 'tprTrees'}

\item{i}{index i}

\item{j}{index j}

\item{...}{not currently used}

\item{drop}{drop dimensions, defaults to FALSE}

\item{object}{object of class 'tprTrees'}
}
\value{
a part of the original object
}
\description{
This class represents one or multiple trees by their biometric
characteristics.

using indices i and j to subset
}
\details{
blabla
}
\section{Methods (by generic)}{
\itemize{
\item \code{x[i}: subsetting for class 'tprTrees'

\item \code{length(tprTrees)}: length function for class 'tprTrees'

\item \code{show(tprTrees)}: length function for class 'tprTrees'

}}
\section{Slots}{

\describe{
\item{\code{spp}}{species code of trees}

\item{\code{Dm}}{list of measured diameters}

\item{\code{Hm}}{list of heights of measured diameters}

\item{\code{Ht}}{total height of trees}

\item{\code{sHt}}{standard deviation of total tree height, defaults to 0 for exact
height measurements without error}

\item{\code{monotone}}{logical indicator about monotonicity of taper curve}
}}

\examples{
tprTrees() # initialise object by constructor
(tmp <- tprTrees(spp=c(1L,3L), Dm=list(c(30, 28), c(40, 38)),
                 Hm=list(c(1.3, 5), c(1.3, 5)), Ht=c(30, 40)))

}
\keyword{methods}
