% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Tariff.plot.r
\name{plot.tariff}
\alias{plot.tariff}
\title{Plot CSMF of the results obtained from Tariff algorithm}
\usage{
\method{plot}{tariff}(x, top = NULL, min.prob = 0, ...)
}
\arguments{
\item{x}{fitted object from \code{\link{tariff}}}

\item{top}{maximum causes to plot}

\item{min.prob}{minimum fraction for the causes plotted}

\item{...}{Arguments to be passed to/from graphic function}
}
\description{
This function plots the CSMF of the fitted results.
}
\examples{
\donttest{
data("RandomVA3")
test <- RandomVA3$test
train <- RandomVA3$train
allcauses <- unique(train$cause)
fit <- tariff(causes.train = "cause", symps.train = train,
				symps.test = test, causes.table = allcauses)
plot(fit, top = 10, main = "Top 5 population COD distribution")
plot(fit, min.prob = 0.05, main = "Ppulation COD distribution (at least 5\%)")
}
}

