% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clsModelContainer.R
\docType{class}
\name{SYS_LSF-class}
\alias{SYS_LSF-class}
\alias{SYS_LSF}
\title{System Limit State Functions}
\description{
Object that represents a limit state function
}
\section{Fields}{

\describe{
\item{\code{expr}}{prepared for expression like SYS_LSF$expr <- expression(f_ck - d_nom)...}

\item{\code{func}}{prepared for objective functions like SYS_LSF$func <- function(x){return(x[1] + x[2])}}

\item{\code{vars}}{needs list of PROB_BASEVAR-Object}

\item{\code{name}}{Can be added for better recognition. Otherwise the problem will be called "Unkown Problem"}
}}

\section{Methods}{

\describe{
\item{\code{ExpressionToFunction()}}{Transforms a valid expression into a objective function. Need the set of Variables with correct spelled names and IDs}

\item{\code{check()}}{Checks all variables. You dont need to execute this, since the system object will do anyway.}
}}

\examples{
list_of_vars <- list(PROB_BASEVAR(),PROB_BASEVAR())
lsf1 <- SYS_LSF(name="my first lsf", vars=list_of_vars)
lsf1$func <- function(var1,var2){var1-var2}

}
\author{
(C) 2021 - K. Nille-Hauf, T. Feiri, M. Ricker - Hochschule Biberach, Institut fuer Konstruktiven Ingenieurbau
}
