% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadow_class.R
\docType{class}
\name{config_Shadow-class}
\alias{config_Shadow-class}
\alias{createShadowTestConfig}
\title{Create a config_Shadow object}
\usage{
createShadowTestConfig(
  item_selection = NULL,
  content_balancing = NULL,
  MIP = NULL,
  MCMC = NULL,
  refresh_policy = NULL,
  exposure_control = NULL,
  stopping_criterion = NULL,
  interim_theta = NULL,
  final_theta = NULL,
  theta_grid = seq(-4, 4, 0.1),
  audit_trail = F
)
}
\arguments{
\item{item_selection}{a named list containing item selection criteria.
\itemize{
  \item{\code{method}} the type of selection criteria. Accepts \code{MFI, MPWI, FB, EB}. (default = \code{MFI})
  \item{\code{info_type}} the type of information. Accepts \code{FISHER}. (default = \code{FISHER})
  \item{\code{initial_theta}} (optional) initial theta values to use.
  \item{\code{fixed_theta}} (optional) fixed theta values to use throughout all item positions.
}}

\item{content_balancing}{a named list containing content balancing options.
\itemize{
  \item{\code{method}} the type of balancing method. Accepts \code{NONE, STA}. (default = \code{STA})
}}

\item{MIP}{a named list containing solver options.
\itemize{
  \item{\code{solver}} the type of solver. Accepts \code{lpsymphony, Rsymphony, gurobi, lpSolve, Rglpk}. (default = \code{LPSOLVE})
  \item{\code{verbosity}} verbosity level of the solver. (default = \code{-2})
  \item{\code{time_limit}} time limit in seconds. Used in solvers \code{lpsymphony, Rsymphony, gurobi, Rglpk}. (default = \code{60})
  \item{\code{gap_limit}} search termination criterion. Gap limit in relative scale passed onto the solver. Used in solver \code{gurobi}. (default = \code{.05})
  \item{\code{gap_limit_abs}} search termination criterion. Gap limit in absolute scale passed onto the solver. Used in solvers \code{lpsymphony, Rsymphony}. (default = \code{0.05})
  \item{\code{retry}} number of times to retry running the solver if the solver returns no solution. Some solvers incorrectly return no solution even when a solution exists. This is the number of attempts to verify that the problem is indeed infeasible in such cases. Set to \code{0} to not retry. (default = \code{5})
}}

\item{MCMC}{a named list containing Markov-chain Monte Carlo configurations for obtaining posterior samples.
\itemize{
  \item{\code{burn_in}} the number of chains from the start to discard. (default = \code{100})
  \item{\code{post_burn_in}} the number of chains to use after discarding the first \code{burn_in} chains. (default = \code{500})
  \item{\code{thin}} thinning interval to apply. \code{1} represents no thinning. (default = \code{1})
  \item{\code{jump_factor}} the jump factor to use. \code{1} represents no jumping. (default = \code{1})
}}

\item{refresh_policy}{a named list containing the refresh policy for when to obtain a new shadow test.
\itemize{
  \item{\code{method}} the type of policy. Accepts \code{ALWAYS, POSITION, INTERVAL, THRESHOLD, INTERVAL-THRESHOLD, STIMULUS, SET, PASSAGE}. (default = \code{ALWAYS})
  \item{\code{interval}} used in methods \code{INTERVAL, INTERVAL-THRESHOLD}. Set to 1 to refresh at each position, 2 to refresh at every two positions, and so on. (default = \code{1})
  \item{\code{threshold}} used in methods \code{THRESHOLD, INTERVAL-THRESHOLD}. The absolute change in between interim theta estimates to trigger the refresh. (default = \code{0.1})
  \item{\code{position}} used in methods \code{POSITION}. Item positions to trigger the refresh. (default = \code{1})
}}

\item{exposure_control}{a named list containing exposure control settings.
\itemize{
  \item{\code{method}} the type of exposure control method. Accepts \code{NONE, ELIGIBILITY, BIGM, BIGM-BAYESIAN}. (default = \code{ELIGIBILITY})
  \item{\code{M}} used in methods \code{BIGM, BIGM-BAYESIAN}. the Big M penalty to use on item information.
  \item{\code{max_exposure_rate}} target exposure rates for each segment. (default = \code{rep(0.25, 7)})
  \item{\code{acceleration_factor}} the acceleration factor to apply. (default = \code{1})
  \item{\code{n_segment}} the number of theta segments to use. (default = \code{7})
  \item{\code{first_segment}} (optional) the theta segment assumed at the beginning of test for all participants.
  \item{\code{segment_cut}} theta segment cuts. (default = \code{c(-Inf, seq(-2.5, 2.5, 1), Inf)})
  \item{\code{initial_eligibility_stats}} (optional) initial eligibility statistics to use.
  \item{\code{fading_factor}} the fading factor to apply. (default = \code{.999})
  \item{\code{diagnostic_stats}} set to \code{TRUE} to generate segment-wise diagnostic statistics. (default = \code{FALSE})
}}

\item{stopping_criterion}{a named list containing stopping criterion.
\itemize{
  \item{\code{method}} the type of stopping criterion. Accepts \code{FIXED}. (default = \code{FIXED})
  \item{\code{test_length}} test length.
  \item{\code{min_ni}} the maximum number of items to administer.
  \item{\code{max_ni}} the minimum number of items to administer.
  \item{\code{se_threshold}} standard error threshold. Item administration is stopped when theta estimate standard error becomes lower than this value.
}}

\item{interim_theta}{a named list containing interim theta estimation options.
\itemize{
  \item{\code{method}} the type of estimation. Accepts \code{EAP, MLE, MLEF, EB, FB}. (default = \code{EAP})
  \item{\code{shrinkage_correction}} set \code{TRUE} to apply shrinkage correction. Used when \code{method} is \code{EAP}. (default = \code{FALSE})
  \item{\code{prior_dist}} the type of prior distribution. Accepts \code{NORMAL, UNIFORM}. (default = \code{NORMAL})
  \item{\code{prior_par}} distribution parameters for \code{prior_dist}. (default = \code{c(0, 1)})
  \item{\code{bound_ML}} theta bound in \code{c(lower_bound, upper_bound)} format. Used when \code{method} is \code{MLE}. (default = \code{-4, 4})
  \item{\code{truncate_ML}} set \code{TRUE} to truncate ML estimate within \code{bound_ML}. (default = \code{FALSE})
  \item{\code{max_iter}} maximum number of Newton-Raphson iterations. Used when \code{method} is \code{MLE}. (default = \code{50})
  \item{\code{crit}} convergence criterion. Used when \code{method} is \code{MLE}. (default = \code{1e-03})
  \item{\code{max_change}} maximum change in ML estimates between iterations. Changes exceeding this value is clipped to this value. Used when \code{method} is \code{MLE}. (default = \code{1.0})
  \item{\code{do_Fisher}} set \code{TRUE} to use Fisher's method of scoring. Used when \code{method} is \code{MLE}. (default = \code{TRUE})
  \item{\code{fence_slope}} slope parameter to use for \code{method = 'MLEF'}. This must have two values in total, for the lower and upper bound item respectively. Use one value to use the same value for both bounds. (default = \code{5})
  \item{\code{fence_difficulty}} difficulty parameters to use for \code{method = 'MLEF'}. This must have two values in total, for the lower and upper bound item respectively. (default = \code{c(-5, 5)})
}}

\item{final_theta}{a named list containing final theta estimation options.
\itemize{
  \item{\code{method}} the type of estimation. Accepts \code{EAP, MLE, MLEF, EB, FB}. (default = \code{EAP})
  \item{\code{shrinkage_correction}} set \code{TRUE} to apply shrinkage correction. Used when \code{method} is \code{EAP}. (default = \code{FALSE})
  \item{\code{prior_dist}} the type of prior distribution. Accepts \code{NORMAL, UNIFORM}. (default = \code{NORMAL})
  \item{\code{prior_par}} distribution parameters for \code{prior_dist}. (default = \code{c(0, 1)})
  \item{\code{bound_ML}} theta bound in \code{c(lower_bound, upper_bound)} format. Used when \code{method} is \code{MLE}. (default = \code{-4, 4})
  \item{\code{truncate_ML}} set \code{TRUE} to truncate ML estimate within \code{bound_ML}. (default = \code{FALSE})
  \item{\code{max_iter}} maximum number of Newton-Raphson iterations. Used when \code{method} is \code{MLE}. (default = \code{50})
  \item{\code{crit}} convergence criterion. Used when \code{method} is \code{MLE}. (default = \code{1e-03})
  \item{\code{max_change}} maximum change in ML estimates between iterations. Changes exceeding this value is clipped to this value. Used when \code{method} is \code{MLE}. (default = \code{1.0})
  \item{\code{do_Fisher}} set \code{TRUE} to use Fisher's method of scoring. Used when \code{method} is \code{MLE}. (default = \code{TRUE})
  \item{\code{fence_slope}} slope parameter to use for \code{method = 'MLEF'}. This must have two values in total, for the lower and upper bound item respectively. Use one value to use the same value for both bounds. (default = \code{5})
  \item{\code{fence_difficulty}} difficulty parameters to use for \code{method = 'MLEF'}. This must have two values in total, for the lower and upper bound item respectively. (default = \code{c(-5, 5)})
}}

\item{theta_grid}{the theta grid to use as quadrature points.}

\item{audit_trail}{set \code{TRUE} to plot audit trails.}
}
\description{
\code{\link{createShadowTestConfig}} is a config function to create a \code{\linkS4class{config_Shadow}} object for Shadow test assembly.
Default values are used for any unspecified parameters/slots.
}
\examples{
cfg1 <- createShadowTestConfig(refresh_policy = list(
  method = "STIMULUS"
))
cfg2 <- createShadowTestConfig(refresh_policy = list(
  method = "POSITION",
  position = c(1, 5, 9)
))
}
