% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tg.R
\name{Tg}
\alias{Tg}
\title{Tg}
\usage{
Tg(x = NULL, Pop = 1, m = NULL, m2 = NULL, f = NULL, f2 = NULL,
  M.mu = NULL, M.mu2 = NULL, F.mu = NULL, F.mu2 = NULL,
  M.sdev = NULL, M.sdev2 = NULL, F.sdev = NULL, F.sdev2 = NULL,
  lower_tail = FALSE, tail = "two", padjust = "none")
}
\arguments{
\item{x}{Data frame containing summary statistics of both sexes for two or
more populations, Default: \code{NULL}}

\item{Pop}{Number of the column containing populations' names, Default:
\code{1}}

\item{m}{Number of male sample size in the first population, Default:
\code{NULL}}

\item{m2}{Number of male sample size in the second population, Default:
\code{NULL}}

\item{f}{Number of female sample size in the first population, Default:
\code{NULL}}

\item{f2}{Number of female sample size in the second population, Default:
\code{NULL}}

\item{M.mu}{Means for males in the first population, Default: \code{NULL}}

\item{M.mu2}{Means for males in the second population, Default: \code{NULL}}

\item{F.mu}{Means for females in the first population, Default: \code{NULL}}

\item{F.mu2}{Means for females in the second population, Default: \code{NULL}}

\item{M.sdev}{Standard deviation for males in the first population, Default:
\code{NULL}}

\item{M.sdev2}{Standard deviation for males in the second population,
Default: \code{NULL}}

\item{F.sdev}{Standard deviation for females in the first population,
Default: \code{NULL}}

\item{F.sdev2}{Standard deviation for females in the second population,
Default: \code{NULL}}

\item{lower_tail}{Logical; if \code{TRUE} probabilities are \code{P[X <= x]},
otherwise, \code{P[X > x]}., Default: \code{FALSE}}

\item{tail}{Number of t test tails, Default: \code{'two'}}

\item{padjust}{Method of p value adjustment for multiple comparisons
following \code{p.adjust.methods}, Default: \code{'none'}}
}
\value{
Degree of freedom, t and p values for Tg test.
}
\description{
Calculates the significance of the differences in degree sexual
  dimorphism between two populations using a modified Greene t-test which
  uses summary statistics as input.
}
\details{
Summary statistics can be entered directly as arguments in case of
  comparing two populations. Alternatively, data can be entered in a wide
  format with each row representing a given population.\code{Pop}  (first
  column by default) contains population names, \code{.mu} and \code{.sdev}
  contain means and standard deviations with \code{M} and \code{F} donating
  males and females. While \code{m}&\code{f} are the male and female sample
  sizes respectively. When more than two populations are entered as
  input,\code{p.adjust.methods:
  c('holm','hochberg','hommel','bonferroni','BH','BY','fdr','none')} can be
  used for p value adjustment.
}
\examples{
 # Summary data in a data frame
Pop <- c('Turkish', 'Bulgarian')
m <- c(150.00, 82.00)
f <- c(150.00, 58.00)
M.mu <- c(49.39, 48.33)
F.mu <- c(42.91, 42.89)
M.sdev <- c(3.01, 2.53)
F.sdev <- c(2.90, 2.84)
df <- cbind.data.frame(
  Pop,
  m,
  f,
  M.mu,
  F.mu,
  M.sdev,
  F.sdev,
  stringsAsFactors = TRUE
)
TestDimorph::Tg(x = df)

}
\references{
\insertRef{greene1989comparison}{TestDimorph}

  \insertRef{timonov2014study}{TestDimorph}

  \insertRef{gulhan2015new}{TestDimorph}
}
