% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-aic-t.R
\name{util_t_aic}
\alias{util_t_aic}
\title{Calculate Akaike Information Criterion (AIC) for t Distribution}
\usage{
util_t_aic(.x)
}
\arguments{
\item{.x}{A numeric vector containing the data to be fitted to a t
distribution.}
}
\value{
The AIC value calculated based on the fitted t distribution to the
provided data.
}
\description{
This function estimates the parameters of a t distribution from the provided
data using maximum likelihood estimation, and then calculates the AIC value
based on the fitted distribution.
}
\details{
This function calculates the Akaike Information Criterion (AIC) for a t
distribution fitted to the provided data.

This function fits a t distribution to the input data using maximum
likelihood estimation and then computes the Akaike Information Criterion (AIC)
based on the fitted distribution.
}
\examples{
# Generate t-distributed data
set.seed(123)
x <- rt(100, df = 5, ncp = 0.5)

# Calculate AIC for the generated data
util_t_aic(x)

}
\seealso{
\code{\link[stats]{rt}} for generating t-distributed data,
\code{\link[stats]{optim}} for optimization.

Other Utility: 
\code{\link{check_duplicate_rows}()},
\code{\link{convert_to_ts}()},
\code{\link{quantile_normalize}()},
\code{\link{tidy_mcmc_sampling}()},
\code{\link{util_beta_aic}()},
\code{\link{util_binomial_aic}()},
\code{\link{util_cauchy_aic}()},
\code{\link{util_chisq_aic}()},
\code{\link{util_exponential_aic}()},
\code{\link{util_f_aic}()},
\code{\link{util_gamma_aic}()},
\code{\link{util_generalized_beta_aic}()},
\code{\link{util_generalized_pareto_aic}()},
\code{\link{util_geometric_aic}()},
\code{\link{util_hypergeometric_aic}()},
\code{\link{util_inverse_burr_aic}()},
\code{\link{util_inverse_pareto_aic}()},
\code{\link{util_inverse_weibull_aic}()},
\code{\link{util_logistic_aic}()},
\code{\link{util_lognormal_aic}()},
\code{\link{util_negative_binomial_aic}()},
\code{\link{util_normal_aic}()},
\code{\link{util_paralogistic_aic}()},
\code{\link{util_pareto1_aic}()},
\code{\link{util_pareto_aic}()},
\code{\link{util_poisson_aic}()},
\code{\link{util_triangular_aic}()},
\code{\link{util_uniform_aic}()},
\code{\link{util_weibull_aic}()},
\code{\link{util_zero_truncated_binomial_aic}()},
\code{\link{util_zero_truncated_geometric_aic}()},
\code{\link{util_zero_truncated_negative_binomial_aic}()},
\code{\link{util_zero_truncated_poisson_aic}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility}
