% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiqc.R
\docType{package}
\name{TidyMultiqc-package}
\alias{TidyMultiqc-package}
\title{TidyMultiqc: Converting MultiQC reports into tidy data frames}
\description{
This package provides the means to convert \code{multiqc_data.json}
files, produced by the wonderful \href{http://multiqc.info/}{MultiQC} tool,
into tidy data.frames for downstream analysis in R. This analysis might
involve cohort analysis, quality control visualisation, changepoint detection,
statistical process control, clustering, or any other type of quality analysis.
}
\section{Core API}{

The public API to this package
\itemize{
\item \code{\link[=load_multiqc]{load_multiqc()}}
}
}

\section{Plot Extractor Functions}{

These functions can be used as arguments to \code{\link[=load_multiqc]{load_multiqc()}} to specify
how to extract data from MultiQC plots
\itemize{
\item \code{\link[=extract_ignore_x]{extract_ignore_x()}}
\item \code{\link[=extract_xy]{extract_xy()}}
\item \code{\link[=extract_histogram]{extract_histogram()}}
}
}

\section{Summary Functions}{

These are also passed as arguments to \code{\link[=load_multiqc]{load_multiqc()}}.
In most cases you can use normal summary statistics like \code{\link[base:mean]{base::mean()}},
but these are some other useful ones you might want.
\itemize{
\item \code{\link[=summary_q30]{summary_q30()}}
\item \code{\link[=summary_extract_df]{summary_extract_df()}}
}
}

