% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TippingPoint.R
\name{TippingPoint}
\alias{TippingPoint}
\title{Generic function for Enhanced Tipping Point Displays}
\usage{
TippingPoint(...)
}
\arguments{
\item{\dots}{Additional arguments, see \code{\link{TippingPoint.default}}, \code{\link{TippingPoint.formula}} for more details.}
}
\description{
Generic function for Enhanced Tipping Point Displays
}
\examples{
TippingPoint(outcome=tippingdata$binary, treat= tippingdata$treat,
  group.infor=TRUE, plot.type = "estimate",ind.values = TRUE,
  impValuesT  = NA,  impValuesC = NA,
  summary.type = "density", alpha = 0.95, S=1.5, n.grid = 100,
  HistMeanT = c(0.38,0.4), HistMeanC =  c(0.2,0.55))
}
\references{
1. Liublinska, V. and Rubin, D.B. Enhanced Tipping-Point Displays. In JSM Proceedings, Section on Survey Research Methods, San Diego, CA: American Statistical Association. 3861-3686 (2012).

2. Liublinska, V. & Rubin, D.B. Sensitivity analysis for a partially missing binary outcome in a two-arm randomized clinical trial. Stat Med 33, 4170-85 (2014).

3. Liublinska, V. (May, 2013) Sensitivity Analyses in Empirical Studies Plagued with Missing Data. PhD Dissertation, Harvard University, \url{https://dash.harvard.edu/handle/1/11124841}

4. \url{https://sites.google.com/site/vliublinska/research}
}
\seealso{
\code{\link{TippingPoint.default}}, \code{\link{TippingPoint.formula}}.
}

