% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_na.R
\name{gg_na}
\alias{gg_na}
\title{Plot missing data}
\usage{
gg_na(df)
}
\arguments{
\item{df}{A data.frame.}
}
\description{
Plots missing data as holes on a black canvas.
}
\examples{
# What a mess. 
# Feature 10 is missing a lot. Observations 25 and 35 are completely missing.
# Most of features 40-45 are missing, except for the first few observations.
set.seed(2016-07-12)
x <- matrix(1, nrow=50, ncol=50)
x[sample(prod(dim(x)), 100)] <- NA
x <- data.frame(x)
x$X10[sample(length(x$X10), 25)] <- NA
x[c(25, 35), ] <- NA
x[1:40, 40:45] <- NA
gg_na(x)

}
\author{
Stephen Turner
}
\keyword{NA}
