% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waci.R
\name{Weighted_Average_Carbon_Intensity}
\alias{Weighted_Average_Carbon_Intensity}
\title{Weighted Average Carbon Intensity}
\usage{
Weighted_Average_Carbon_Intensity(portfolio_exposure, emissions_revenue_data)
}
\arguments{
\item{portfolio_exposure}{The exposure per issuer in the portfolio}

\item{emissions_revenue_data}{The capitalization, revenue and the Scope 1 & 2 GHG emissions per issuer}
}
\value{
Total carbon emissions for a portfolio normalized by the market value of the portfolio, expressed in tons CO2e / $M invested.
}
\description{
Returns the portfolio's exposure to each issuer expressed in tons CO2e / $M revenue.
Scope 1 and Scope 2 GHG emissions are allocated based on portfolio weights (the current value of
the investment relative to the current portfolio value), rather than the equity ownership approach
}
\examples{
 portfolio_exposure     = data.table::data.table(Issuers = c('A','B','C'),
  exposures = c(100, 200, 50))
 emissions_revenue_data = data.table::data.table(Issuers = c('A','B','C'), 
 emissions = c(1000, 5000, 2000),
  revenue = c(2000, 5000, 3000))
 Weighted_Average_Carbon_Intensity(portfolio_exposure, emissions_revenue_data)
}
\references{
https://www.tcfdhub.org/Downloads/pdfs/E09%20-%20Carbon%20footprinting%20-%20metrics.pdf
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
