% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrepDeseq2.R
\name{prep_deseq2}
\alias{prep_deseq2}
\title{Prepare DESeq2 data for plotting}
\usage{
prep_deseq2(input_path, output_name = NULL)
}
\arguments{
\item{input_path}{Path to the RDS file containing the DESeq2 DEG data frame.}

\item{output_name}{Name for the processed data frame, also used as the RDS file name.}
}
\value{
A data frame with processed DESeq2 DEG data.
}
\description{
This function reads a DESeq2 DEG data frame from an RDS file, filters it,
adjusts the log2FoldChange to absolute values, adds a pseudo-count to pvalues,
and transforms pvalues for plotting. The final data frame is returned and
optionally saved to a new RDS file.
}
\examples{
deseq2_file <- system.file("extdata",
                           "DEG_deseq2_test.rds",
                           package = "TransProR")
deseq2 <- prep_deseq2(deseq2_file)

}
