% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TBR.R
\name{TBR}
\alias{TBR}
\alias{TBRSwap}
\alias{RootedTBR}
\alias{RootedTBRSwap}
\title{TBR}
\usage{
TBR(tree, edgeToBreak = NULL, mergeEdges = NULL)

TBRSwap(parent, child, nEdge = length(parent), edgeToBreak = NULL,
  mergeEdges = NULL)

RootedTBR(tree, edgeToBreak = NULL, mergeEdges = NULL)

RootedTBRSwap(parent, child, nEdge = length(parent), edgeToBreak = NULL,
  mergeEdges = NULL)
}
\arguments{
\item{tree}{A bifurcating tree of class \code{\link{phylo}}, with all nodes resolved;}

\item{edgeToBreak}{(optional) integer specifying the index of an edge to bisect/prune,
generated randomly if not specified.  Alternatively, set to \code{-1} to return a complete list
of all trees one step from the input tree.}

\item{mergeEdges}{(optional) vector of length 1 or 2, listing edge(s) to be joined:
In SPR, this is where the pruned subtree will be reconnected.
In TBR, these edges will be reconnected (so must be on opposite
sides of \code{edgeToBreak}); if only a single edge is specified,
the second will be chosen at random}

\item{parent}{the first column of the edge matrix of a tree of class \code{\link{phylo}}, i.e. tree$edge[, 1]}

\item{child}{the second column of the edge matrix of a tree of class \code{\link{phylo}}, i.e. tree$edge[, 2]}

\item{nEdge}{(optional) Number of edges.}
}
\value{
This function returns a tree in \code{phyDat} format that has undergone one \acronym{TBR} iteration.

a list containing two elements, corresponding in turn to the rearranged parent and child parameters
}
\description{
Tree bisection and reconnection

Rooted TBR
}
\details{
\code{TBR} performs a single random \acronym{TBR} iteration.

Branch lengths are not (yet) supported.
}
\section{Functions}{
\itemize{
\item \code{TBRSwap}: faster version that takes and returns parent and child parameters

\item \code{RootedTBR}: Perform \acronym{TBR} rearrangement, retaining position of root

\item \code{RootedTBRSwap}: faster version that takes and returns parent and child parameters
}}

\examples{
{
library('ape')
tree <- rtree(20, br=NULL)
TBR(tree)
}
}
\references{
The \acronym{TBR} algorithm is summarized in
 \insertRef{Felsenstein2004}{TreeSearch}
}
\seealso{
RootedTBR useful when the position of the root node should be retained.
}
\author{
Martin R. Smith
}
