% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fitch.R
\name{CharacterLength}
\alias{CharacterLength}
\alias{FitchSteps}
\alias{FastCharacterLength}
\title{Character length}
\usage{
CharacterLength(tree, dataset)

FitchSteps(tree, dataset)

FastCharacterLength(tree, dataset)
}
\arguments{
\item{tree}{A tree of class \code{\link{phylo}}.}

\item{dataset}{A phylogenetic data matrix of class \code{\link[phangorn]{phyDat}},
whose names correspond to the labels of any accompanying tree.}
}
\value{
\code{CharacterLength()} returns a vector listing the contribution of each
character to tree score, according to the algorithm of Brazeau, Guillerme
and Smith (2019).
}
\description{
Homoplasy length of each character in a dataset on a specified tree.
}
\section{Functions}{
\itemize{
\item \code{FastCharacterLength}: Do not perform checks.  Use with care: may cause
erroneous results or  software crash if variables are in the incorrect format.
}}

\examples{
data('inapplicable.datasets')
dataset <- inapplicable.phyData[[12]]
tree <- TreeTools::NJTree(dataset)
CharacterLength(tree, dataset)

}
\references{
\insertRef{Brazeau2018}{TreeSearch}
}
\seealso{
Other tree scoring: \code{\link{Fitch}},
  \code{\link{IWScore}}, \code{\link{MorphyTreeLength}}
}
\concept{tree scoring}
