% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{profiles}
\alias{profiles}
\title{Empirically counted profiles for small trees}
\format{
A list with the structure
\verb{profiles[[number of leaves]][[number of tokens]][[tokens in smallest split]]}
The list entry returns a named numeric vector; each entry lists
log2(proportion of \emph{n}-leaf trees with \emph{s} or fewer steps for this character).
}
\usage{
profiles
}
\description{
The base 2 logarithm of the number of trees containing \emph{s} steps, calculated
by scoring a character on each \emph{n}-leaf tree.
}
\examples{
data(profiles)

# Load profile for a character of the structure 0 0 0 1 1 1 1 1
profile3.5 <- profiles[[8]][[2]][[3]]

# Number of trees with _s_ or fewer steps on that character
TreeTools::NUnrooted(8) * 2 ^ profile3.5
}
\seealso{
Other profile parsimony functions: 
\code{\link{Carter1}()},
\code{\link{PrepareDataProfile}()},
\code{\link{StepInformation}()}
}
\concept{profile parsimony functions}
\keyword{datasets}
