% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_numbering.R
\name{RenumberTree}
\alias{RenumberTree}
\alias{RenumberEdges}
\title{Renumber a tree in preorder}
\usage{
RenumberTree(parent, child)

RenumberEdges(parent, child, nEdge = length(parent))
}
\arguments{
\item{parent}{the first column of the edge matrix of a tree of class
\code{\link{phylo}}, i.e. \code{tree$edge[, 1]}.}

\item{child}{the second column of the edge matrix of a tree of class
\code{\link{phylo}}, i.e. \code{tree$edge[, 2]}.}
}
\value{
\code{RenumberTree} returns an edge matrix for a tree of class \code{phylo}
following the usual preorder convention for edge and node numbering.

\code{RenumberEdges} returns a list whose two entries correspond
to the new parent and child vectors.
}
\description{
Wrapper for the C function \code{preorder_edges_and_nodes}, which
renumbers internal nodes and orders edges in preorder, in an order
guaranteed to be identical for any tree of an equivalent topology.
At each node, child edges are arranged from left to right according to the
lowest-numbered tip in the subtree subtended by each edge.
}
\section{Functions}{
\itemize{
\item \code{RenumberEdges}: Returns in list format
}}

\seealso{
\code{\link{SortTree}}

Other C wrappers: \code{\link{Cladewise}},
  \code{\link{Neworder}}
}
\concept{C wrappers}
\keyword{internal}
