% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylo.R
\name{AddTip}
\alias{AddTip}
\alias{AddTipEverywhere}
\title{Add a tip to a phylogenetic tree}
\usage{
AddTip(
  tree,
  where = sample.int(tree$Nnode * 2 + 2L, size = 1) - 1L,
  label = "New tip"
)

AddTipEverywhere(tree, label = "New tip", includeRoot = FALSE)
}
\arguments{
\item{tree}{A tree of class \code{\link{phylo}}.}

\item{where}{The node or tip that should form the sister taxon to the new
node.  To add a new tip at the root, use \code{where = 0}.  By default, the
new tip is added to a random edge.}

\item{label}{Character string providing the label to apply to the new tip.}

\item{includeRoot}{Logical; if \code{TRUE}, the three positions adjacent
to the root edge are considered to represent distinct edges.}
}
\value{
\code{AddTip()} returns a tree of class \code{phylo} with an additional tip
at the desired location.

\code{AddTipEverywhere()} returns a list of class \code{multiPhylo} containing
the trees produced by adding \code{label} to each edge of \code{tree} in turn.
}
\description{
\code{AddTip} adds a tip to a phylogenetic tree at a specified location.
}
\details{
\code{AddTip} extends \code{\link{bind.tree}}, which cannot handle
single-taxon trees.
}
\section{Functions}{
\itemize{
\item \code{AddTipEverywhere}: Add a tip to each edge in turn.
}}

\examples{

plot(tree <- BalancedTree(10))
ape::nodelabels()
ape::nodelabels(15, 15, bg='green')

plot(AddTip(tree, 15, 'NEW_TIP'))

oldPar <- par(mfrow=c(2, 4), mar=rep(0.3, 4), cex=0.9)

backbone <- BalancedTree(4)
additions <- AddTipEverywhere(backbone, includeRoot = TRUE)
xx <- lapply(additions, plot)

par(mfrow=c(2, 3))
additions <- AddTipEverywhere(backbone, includeRoot = FALSE)
xx <- lapply(additions, plot)

par(oldPar)

}
\seealso{
\code{\link{bind.tree}}

\code{\link{nodelabels}}

Other tree manipulation: 
\code{\link{Renumber}()},
\code{\link{SingleTaxonTree}()},
\code{\link{Subtree}()}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree manipulation}
\keyword{tree}
