library(ape)

context("Tree rearrangements")

test_that("RootOnNode works", {

  tree <- structure(list(edge = structure(c(6L, 9L, 9L, 7L, 7L, 8L, 8L,
                                            6L, 9L, 2L, 7L, 3L, 8L, 4L, 5L, 1L),
                                          .Dim = c(8L, 2L)),
                         tip.label = c("t3", "t4", "t1", "t2", "t5"), Nnode = 4L),
                    class = "phylo", order = "cladewise")

  exp8 <- structure(list(edge = structure(c(6L, 7L, 8L, 8L, 7L, 6L, 9L, 9L, 7L, 8L, 1L, 2L, 3L, 9L, 4L, 5L), .Dim = c(8L, 2L)), tip.label = c("t3", "t4", "t1", "t2", "t5"), Nnode = 4L), class = "phylo", order = "preorder")
  exp7 <- structure(list(edge = structure(c(6L, 7L, 7L, 6L, 8L, 8L, 9L, 9L, 7L, 1L, 2L, 8L, 3L, 9L, 4L, 5L), .Dim = c(8L, 2L)), tip.label = c("t3", "t4", "t1", "t2", "t5"), Nnode = 4L), class = "phylo", order = "preorder")
  exp5 <- structure(list(edge = structure(c(6L, 7L, 8L, 9L, 9L, 8L, 7L, 6L, 7L, 8L, 9L, 1L, 2L, 3L, 4L, 5L), .Dim = c(8L, 2L)), tip.label = c("t3", "t4", "t1", "t2", "t5"), Nnode = 4L), class = "phylo", order = "preorder")
  exp4 <- structure(list(edge = structure(c(6L, 7L, 8L, 9L, 9L, 8L, 7L, 6L, 7L, 8L, 9L, 1L, 2L, 3L, 5L, 4L), .Dim = c(8L, 2L)), tip.label = c("t3", "t4", "t1", "t2", "t5"), Nnode = 4L), class = "phylo", order = "preorder")
  exp3 <- structure(list(edge = structure(c(6L, 7L, 8L, 8L, 7L, 9L, 9L, 6L, 7L, 8L, 1L, 2L, 9L, 4L, 5L, 3L), .Dim = c(8L, 2L)), tip.label = c("t3", "t4", "t1", "t2", "t5"), Nnode = 4L), class = "phylo", order = "preorder")
  exp2 <- structure(list(edge = structure(c(6L, 7L, 7L, 8L, 8L, 9L, 9L, 6L, 7L, 1L, 8L, 3L, 9L, 4L, 5L, 2L), .Dim = c(8L, 2L)), tip.label = c("t3", "t4", "t1", "t2", "t5"), Nnode = 4L), class = "phylo", order = "preorder")
  #t2 <- Preorder(t2)
  expect_equal(tree, RootOnNode(tree, node = 9L, TRUE))
  expect_equal(exp8, RootOnNode(tree, node = 8L, TRUE))
  expect_equal(exp7, RootOnNode(tree, node = 7L, TRUE))
  expect_equal(tree, RootOnNode(tree, node = 6L, TRUE))

  expect_equal(exp5, RootOnNode(tree, node = 5L, TRUE))
  expect_equal(exp4, RootOnNode(tree, node = 4L, TRUE))
  expect_equal(exp3, RootOnNode(tree, node = 3L, TRUE))
  expect_equal(exp2, RootOnNode(tree, node = 2L, TRUE))
  expect_equal(tree, RootOnNode(tree, node = 1L, TRUE))
  expect_equal(tree, RootOnNode(unroot(tree), node = 1L, TRUE))


  TestTip <- function (tr, node, rr) {
    expect_equal(Preorder(ape::root(tr, outgroup = node, resolve.root = rr)),
                 RootOnNode(tr, node, rr))
  }
  TestInternal <- function (tr, node, rr) {
    expect_equal(Preorder(ape::root(tr, node = node, resolve.root = rr)),
                 RootOnNode(tr, node, rr))
  }

  TestInternal(PectinateTree(8), 14, TRUE)
  TestInternal(PectinateTree(8), 14, FALSE)
  TestTip(PectinateTree(8), 4L, TRUE)
  TestTip(PectinateTree(8), 4L, FALSE)

  TestInternal(BalancedTree(8L), 11L, TRUE)
  TestInternal(BalancedTree(8L), 11L, FALSE)

  urt <- UnrootedTreeWithShape(3, 8, letters[1:8])
  TestInternal(urt, 12, TRUE)
  TestInternal(urt, 12, FALSE)
  TestTip(urt, 4L, TRUE)
  TestTip(urt, 4L, FALSE)

  # Children of an unresolved root
  TestInternal(urt, 10, TRUE)
  TestTip(urt, 1, TRUE)

  expect_equal(PectinateTree(8), RootOnNode(PectinateTree(8), 9L, TRUE))
  expect_equal(unroot(PectinateTree(8)), RootOnNode(PectinateTree(8), 9L, FALSE))
  expect_equal(urt, RootOnNode(urt, 9L, FALSE))
  expect_equal(Preorder(EnforceOutgroup(urt, letters[1:2])),
               RootOnNode(urt, 9L, TRUE))

})

test_that("CollapseNodes works", {
  tree8  <- read.tree(text="(((a, (b, (c, d))), (e, f)), (g, h));")
  expect_error(CollapseNode(1:5, tree8))
  expect_error(CollapseNode(tree8, 1))

  tree <- as.phylo(123, 7)
  tree$edge.length <- 12:1
  expect_equal(tree, CollapseNode(tree, integer(0)))

  exp1213 <- matrix(c(8, 8, 9, 10, 10, 9, 11, 11, 11, 11,
                      1, 9, 10, 2, 4, 11, 3, 7, 6, 5), ncol=2)
  no1213 <- CollapseNode(tree, c(12, 13))
  expect_equal(exp1213, no1213$edge)

  el <- tree$edge.length
  expect_equal(no1213$edge.length, c(el[1:6],
                                     el[7] + c(c(el[8] + el[9:10]), el[11]),
                                     el[12]))

  no11 <- CollapseEdge(tree, c(7, 8))
  expect_equal(exp1213, no11$edge)

})
