% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TPCfunctions.R
\name{TPC_beta}
\alias{TPC_beta}
\title{Beta Function Thermal Performance Curve}
\usage{
TPC_beta(T_b, shift = -1, breadth = 0.1, aran = 0, tolerance = 43, skew = 0.7)
}
\arguments{
\item{T_b}{\code{numeric} temperature (C).}

\item{shift}{\code{numeric} mode of the thermal performance curve.}

\item{breadth}{\code{numeric} breadth of the thermal performance curve.}

\item{aran}{\code{numeric} scale performance value. If \code{0}, no scaling; if \code{1}, include a thermodynamic effect on mean performance.}

\item{tolerance}{\code{numeric} maximal breath (C) of the thermal performance curve.}

\item{skew}{\code{numeric} skewness of the thermal performance curve (0-1).}
}
\value{
\code{numeric} performance.
}
\description{
The function constructs a thermal performance curve based on a beta function \insertCite{Asbury2010}{TrenchR}.
}
\examples{
  TPC_beta(T_b       = 0:60, 
           shift     = -1, 
           breadth   = 0.1, 
           aran      = 0, 
           tolerance = 43, 
           skew      = 0.7)

}
\references{
\insertAllCited{}
}
