% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllometricFunctions.R
\name{surface_area_from_length}
\alias{surface_area_from_length}
\title{Organism Surface Area from Length}
\usage{
surface_area_from_length(l)
}
\arguments{
\item{l}{\code{numeric} length (m).}
}
\value{
\code{numeric} surface area (\ifelse{html}{\out{m<sup>2</sup>}}{\eqn{m^2}{ASCII}}).
}
\description{
This function estimates surface area (\ifelse{html}{\out{m<sup>2</sup>}}{\eqn{m^2}{ASCII}}) from length (m) by approximating the animal's body as a rotational ellipsoid with half the body length as the semi-major axis.
}
\details{
Following \insertCite{Samietz2005;textual}{TrenchR} and \insertCite{Lactin1998;textual}{TrenchR}.
}
\examples{
  surface_area_from_length(l = 0.04)

}
\references{
\insertAllCited{}
}
\seealso{
Other allometric functions: 
\code{\link{mass_from_length}()},
\code{\link{proportion_silhouette_area_shapes}()},
\code{\link{proportion_silhouette_area}()},
\code{\link{surface_area_from_mass}()},
\code{\link{surface_area_from_volume}()},
\code{\link{volume_from_length}()}
}
\concept{allometric functions}
