% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TempWindProfileFunctions.R
\name{surface_roughness}
\alias{surface_roughness}
\title{Surface Roughness from Empirical Measurements}
\usage{
surface_roughness(u_r, zr)
}
\arguments{
\item{u_r}{\code{numeric} wind velocity (\ifelse{html}{\out{m s<sup>-1</sup>}}{\eqn{m s^-1}{ASCII}}) at a vector of reference heights.}

\item{zr}{\code{numeric} vector of reference heights (m).}
}
\value{
\code{numeric} surface roughness (m).
}
\description{
The function estimates surface roughness (m) from empirical wind speed (\ifelse{html}{\out{m s<sup>-1</sup>}}{\eqn{m s^-1}{ASCII}}) data collected at a vector of heights (m) \insertCite{Kingsolver2015,Campbell1998,Porter1979}{TrenchR}.
}
\examples{
  surface_roughness(u_r = c(0.01, 0.025, 0.05, 0.1, 0.2), 
                    zr  = c(0.05, 0.25, 0.5, 0.75, 1))

}
\references{
\insertAllCited{}
}
\seealso{
Other microclimate functions: 
\code{\link{air_temp_profile_neutral}()},
\code{\link{air_temp_profile_segment}()},
\code{\link{air_temp_profile}()},
\code{\link{degree_days}()},
\code{\link{direct_solar_radiation}()},
\code{\link{diurnal_radiation_variation}()},
\code{\link{diurnal_temp_variation_sineexp}()},
\code{\link{diurnal_temp_variation_sinesqrt}()},
\code{\link{diurnal_temp_variation_sine}()},
\code{\link{monthly_solar_radiation}()},
\code{\link{partition_solar_radiation}()},
\code{\link{proportion_diffuse_solar_radiation}()},
\code{\link{solar_radiation}()},
\code{\link{wind_speed_profile_neutral}()},
\code{\link{wind_speed_profile_segment}()}
}
\concept{microclimate functions}
