% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllometricFunctions.R
\name{volume_from_length}
\alias{volume_from_length}
\title{Organism Volume from Length}
\usage{
volume_from_length(l, taxon)
}
\arguments{
\item{l}{\code{numeric} length (m). 
\cr
Use snout-vent length for lizards and frogs.}

\item{taxon}{\code{character} taxon of organism, current choices: \code{"lizard"}, \code{"frog"}, \code{"sphere"}.}
}
\value{
\code{numeric} volume (\ifelse{html}{\out{m<sup>3</sup>}}{\eqn{m^3}{ASCII}}).
}
\description{
The function estimates volume (\ifelse{html}{\out{m<sup>3</sup>}}{\eqn{m^3}{ASCII}}) from length (m) for a variety of taxa following \insertCite{Mitchell1976;textual}{TrenchR}.
}
\details{
Relationships come from \itemize{
  \item Lizards: \insertCite{Norris1965;textual}{TrenchR}
  \item Frogs: \insertCite{Tracy1972;textual}{TrenchR}
  \item Sphere: \insertCite{Mitchell1976;textual}{TrenchR}
 }
}
\examples{
  volume_from_length(l     = 0.05,  
                     taxon = "lizard")
  volume_from_length(l     = 0.05,   
                     taxon = "frog")
  volume_from_length(l     = 0.05,   
                     taxon = "sphere")

}
\references{
\insertAllCited{}
}
\seealso{
Other allometric functions: 
\code{\link{mass_from_length}()},
\code{\link{proportion_silhouette_area_shapes}()},
\code{\link{proportion_silhouette_area}()},
\code{\link{surface_area_from_length}()},
\code{\link{surface_area_from_mass}()},
\code{\link{surface_area_from_volume}()}
}
\concept{allometric functions}
