% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arms.R
\docType{class}
\name{Arms}
\alias{Arms}
\title{Class of Arm}
\description{
Create a class of arm.
}
\examples{
# Instead of using Arm$new, please use arm(), a user-friendly
# wrapper. See examples in ?arm

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Arms-new}{\code{Arms$new()}}
\item \href{#method-Arms-add_endpoints}{\code{Arms$add_endpoints()}}
\item \href{#method-Arms-get_name}{\code{Arms$get_name()}}
\item \href{#method-Arms-get_number_endpoints}{\code{Arms$get_number_endpoints()}}
\item \href{#method-Arms-has_endpoint}{\code{Arms$has_endpoint()}}
\item \href{#method-Arms-get_endpoints}{\code{Arms$get_endpoints()}}
\item \href{#method-Arms-get_endpoints_name}{\code{Arms$get_endpoints_name()}}
\item \href{#method-Arms-generate_data}{\code{Arms$generate_data()}}
\item \href{#method-Arms-print}{\code{Arms$print()}}
\item \href{#method-Arms-clone}{\code{Arms$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Arms-new"></a>}}
\if{latex}{\out{\hypertarget{method-Arms-new}{}}}
\subsection{Method \code{new()}}{
initialize an arm
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arms$new(name, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name of arm, which is the arm's label in generated data}

\item{\code{...}}{subset condition that is compatible with \code{dplyr::filter}.
This can be used to specify inclusion criteria of an arm.
By default it is not specified, i.e. all data generated by the generator
specified in \code{...}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Arms-add_endpoints"></a>}}
\if{latex}{\out{\hypertarget{method-Arms-add_endpoints}{}}}
\subsection{Method \code{add_endpoints()}}{
add a list of endpoints to the arm
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arms$add_endpoints(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{one or more objects of class \code{Endpoint}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Arms-get_name"></a>}}
\if{latex}{\out{\hypertarget{method-Arms-get_name}{}}}
\subsection{Method \code{get_name()}}{
return name of arm
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arms$get_name()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Arms-get_number_endpoints"></a>}}
\if{latex}{\out{\hypertarget{method-Arms-get_number_endpoints}{}}}
\subsection{Method \code{get_number_endpoints()}}{
return number of endpoints in the arm
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arms$get_number_endpoints()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Arms-has_endpoint"></a>}}
\if{latex}{\out{\hypertarget{method-Arms-has_endpoint}{}}}
\subsection{Method \code{has_endpoint()}}{
check if the arm has any endpoint. Return \code{TRUE} or \code{FALSE}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arms$has_endpoint()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Arms-get_endpoints"></a>}}
\if{latex}{\out{\hypertarget{method-Arms-get_endpoints}{}}}
\subsection{Method \code{get_endpoints()}}{
return a list of endpoints in the arm
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arms$get_endpoints()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Arms-get_endpoints_name"></a>}}
\if{latex}{\out{\hypertarget{method-Arms-get_endpoints_name}{}}}
\subsection{Method \code{get_endpoints_name()}}{
return name of endpoints registered to the arm
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arms$get_endpoints_name()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Arms-generate_data"></a>}}
\if{latex}{\out{\hypertarget{method-Arms-generate_data}{}}}
\subsection{Method \code{generate_data()}}{
generate arm data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arms$generate_data(n_patients_in_arm)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_patients_in_arm}}{integer. Number of patients randomized to the arm}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Arms-print"></a>}}
\if{latex}{\out{\hypertarget{method-Arms-print}{}}}
\subsection{Method \code{print()}}{
print an arm
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arms$print(categorical_vars = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{categorical_vars}}{categorical_vars character. Vector of categorical variables. This can
be used to specify variables with limited distinct values as categorical
variables in summary.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Arms-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Arms-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arms$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
