% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PiecewiseConstantExponentialRNG.R
\name{PiecewiseConstantExponentialRNG}
\alias{PiecewiseConstantExponentialRNG}
\title{Generate time-to-event endpoint from piecewise constant exponential distribution}
\usage{
PiecewiseConstantExponentialRNG(n, risk, endpoint_name)
}
\arguments{
\item{n}{number of random numbers}

\item{risk}{a data frame of columns
\describe{
\item{\code{end_time}}{ End time for a constant risk in a time window. The start time of the first time window is 0.}
\item{\code{piecewise_risk}}{ A constant risk in a time window, which is absolute risk * relative risk, or (h0 * g) in the link.}
\item{\code{hazard_ratio}}{ An optional column for simulating an active arm. If absent, a column of 1s will be added. Equivalently, user can multiply piecewise_risk by hazard_ratio manually and ignore this column.}
}}

\item{endpoint_name}{name of endpoint}
}
\description{
Implementation is based on \href{https://www.demogr.mpg.de/papers/technicalreports/tr-2010-003.pdf}{this algorithm}.
}
\examples{
# example code
# In this example, absolute risk in [0, 1) and [26, 52] are 0.0181 and
# 0.0027, respectively.
risk <- data.frame(
  end_time = c(1, 4.33, 26.0, 52.0),
  piecewise_risk = c(1, 1.01, 0.381, 0.150) * exp(-4.01)
)
PiecewiseConstantExponentialRNG(10, risk, 'PFS')

}
