% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arm.R
\name{arm}
\alias{arm}
\title{Define an Arm}
\usage{
arm(name, ...)
}
\arguments{
\item{name}{name of arm, which is the arm's label in generated data}

\item{...}{subset condition that is compatible with \code{dplyr::filter}.
This can be used to specify inclusion criteria of an arm.
By default it is not specified, i.e. all data generated by the generator
specified in \code{...}.}
}
\description{
Define an arm in a trial. This is a user-friendly wrapper for
the class constructor \code{Arm$new}. Users who are not familiar with
the concept of classes may consider using this wrapper directly.
}
\examples{

risk <- data.frame(
  end_time = c(1, 10, 26.0, 52.0),
  piecewise_risk = c(1, 1.01, 0.381, 0.150) * exp(-3.01)
)

pfs <- endpoint(name = 'pfs', type='tte',
generator = PiecewiseConstantExponentialRNG,
risk = risk, endpoint_name = 'pfs')

orr <- endpoint(
  name = 'orr', type = 'non-tte',
  readout = c(orr = 2), generator = rbinom,
  size = 1, prob = .4)

placebo <- arm(name = 'pbo')

placebo$add_endpoints(pfs, orr)
placebo
head(placebo$get_endpoints()[[1]]$get_generator()(n = 1e3))
placebo$get_endpoints()[[2]]$get_name()

## print summary reports for endpoint objects in console
# placebo

}
