% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genericFunctions.R
\name{init.parms}
\alias{init.parms}
\title{Initialize parameters}
\usage{
init.parms(y)
}
\arguments{
\item{y}{output of rtrunc}
}
\value{
A vector of parameter estimates for the input sample
}
\description{
Returns the empirical parameter estimate for a distribution
}
\examples{
# Normal distribution
sampNorm <- rtrunc(50, mean = 5, sd = 2)
init.parms(sampNorm)

# Poisson distribution
sampPois <- rtrunc(10, lambda = 100, family = "Poisson")
init.parms(sampPois)
}
