% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sentiment_tweets.R
\name{get_sentiment_tweets}
\alias{get_sentiment_tweets}
\title{get_sentiment_tweets}
\usage{
get_sentiment_tweets(
  ntweets,
  time_tweet,
  terms_list,
  time_zone,
  positive_dictionary,
  negative_dictionary,
  sentiment_index_type
)
}
\arguments{
\item{ntweets}{Number of tweets to be searched}

\item{time_tweet}{Time in hours where the tweets will be filtered}

\item{terms_list}{Terms to be searched}

\item{time_zone}{The time zone}

\item{positive_dictionary}{The list of positive terms of the dictionary}

\item{negative_dictionary}{The list of negative terms of the dictionarya tibble with the words counting}

\item{sentiment_index_type}{The sentiment type to be used according to the dictionary, positive, negative or both. Default is both, positive and negative}
}
\value{
A list with: (1) - the sentiment index, (2) a tibble with the words counting, (3) a tibble with the negative words counting and (4
}
\description{
This function computes the sentiment from tweets. Remind to connect with twitter using your API Key.
}
\examples{
\dontrun{
#Not run:
ntweets <- 500
time_tweet <- 6
terms_list <- c("IBOVESPA OR bovespa OR ibov OR petroleo OR $SPX OR $SPY OR $EWZ")
time_zone <- "Brazil/East"
positive_dictionary <- my_dictionary[['positive_terms']]
negative_dictionary <- my_dictionary[['negative_terms']]
sentiment_index <- get_sentiment_tweets(ntweets = ntweets,
terms_list = terms_list,
time_tweet = time_tweet,
time_zone = time_zone,
positive_dictionary = positive_dictionary,
negative_dictionary = negative_dictionary
)

sent_idx <- sentiment_index[[1]]
sent_wrd <- sentiment_index[[2]]
sent_pos <- sentiment_index[[3]]
sent_neg <- sentiment_index[[4]]
}

}
