% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{GumbelEst}
\alias{GumbelEst}
\title{Gumbel distribution estimates from parameters}
\usage{
GumbelEst(loc, scale, q = NULL, RP = 100)
}
\arguments{
\item{loc}{location parameter}

\item{scale}{scale parameter}

\item{q}{quantile. magnitude of the variable under consideration}

\item{RP}{return period}
}
\value{
quantile as a function of RP or vice versa
}
\description{
Estimated quantiles as function of return period (RP) and vice versa, from user input parameters
}
\details{
If the argument q is used, it overrides RP and provides RP as a function of q (magnitude of variable) as opposed to q as a function of RP.
}
\examples{
#Get an annual maximum sample, estimate the parameters and estimate 50-year RP
AM.27090 <- GetAM(27090)
Pars <- as.numeric(GumbelPars(AM.27090$Flow))
GumbelEst(Pars[1], Pars[2], RP = 50)
#Estimate the RP for a 600m3/s discharge
GumbelEst(Pars[1], Pars[2], q = 600)
}
\author{
Anthony Hammond
}
