% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{LcvUrb}
\alias{LcvUrb}
\title{Urban adjustment for the linear coefficient of variation (Lcv)}
\usage{
LcvUrb(lcv, URBEXT2000, DeUrb = FALSE)
}
\arguments{
\item{lcv}{the Lcv (numeric)}

\item{URBEXT2000}{quantiication of urban and suburbanisation for the subject catchment}

\item{DeUrb}{logical argument with a default of FALSE. If set to TRUE, de-urbanisation adjustment is performed, if FALSE, urbanisation adjustment is performed}
}
\value{
The urban adjust Lcv or the de-urbanised Lcv
}
\description{
Urbanises or de-urbanises the Lcv using the methods outlined in the guidance by Wallingford HydroSolutions: 'WINFAP 4 Urban Adjustment Procedures'
}
\details{
The method for de-urbanisation isn't explicitly provided in 'WINFAP 4 Urban Adjustment Procedures', but the procedure is a re-arrangment of the urbanisation equation, solving for Lcv rather than Lcv-urban.
}
\examples{
#Choose an urban site (site 53006) from the NRFA data then apply a de-urban
#adjustment using the Lcv and URBEXT2000 displayed
NRFAData[which(rownames(NRFAData) == 53006),]
LcvUrb(0.21, 0.1138, DeUrb = TRUE)
#Get the pooled Lmoment ratios results for catchment 53006 and apply the
#urban adjustment using the pooled Lcv, and the URBEXT2000 for site 53006.
CDs.53006 <- GetCDs(53006)
QuickResults(CDs.53006)[[2]]
LcvUrb(0.196, 0.1138)
}
\author{
Anthony Hammond
}
