% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{WGaugLSkew}
\alias{WGaugLSkew}
\title{Gauged pool weighted linear skewness (LSkew)}
\usage{
WGaugLSkew(x)
}
\arguments{
\item{x}{pooling group derived with the Pool() function}
}
\value{
the gauged weighted LSkew from a pooling group
}
\description{
Calculates the gauged weighted LSkew from a pooling group (enhanced single site)
}
\details{
Weighting method as according to Science Report: SC050050 - Improving the FEH statistical procedures for flood frequency estimation
}
\examples{
#Get some CDs, form a gauged pooling group, and estimate gauged LSkew
CDs.96001 <- GetCDs(96001)
Pool.96001 <- Pool(CDs.96001)
WGaugLSkew(Pool.96001)
}
\author{
Anthony Hammond
}
