% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{Kappa3Pars}
\alias{Kappa3Pars}
\title{Kappa3 distribution parameter estimates}
\usage{
Kappa3Pars(x = NULL, L1, LCV, LSKEW)
}
\arguments{
\item{x}{numeric vector. The sample}

\item{L1}{first Lmoment}

\item{LCV}{linear coefficient of variation}

\item{LSKEW}{linear skewness}
}
\value{
Parameter estimates (location, scale, shape)
}
\description{
Estimated parameters from a sample (using Lmoments) or from user supplied L1 (first L-moment), Lcv (linear coefficient of variation), and LSkew (linear skewness)
}
\details{
The L-moment estimated parameters are by the method detailed in 'Hosking J. Wallis J. 1997 Regional Frequency Analysis: An Approach Based on L-moments. Cambridge University Press, New York'. The Kappa3 distribution is as defined by This is the Kappa3 distribution as defined in Kjeldsen, T (2019), 'The 3-parameter Kappa distribution as an alternative for use with FEH pooling groups.'Circulation - The Newsletter of the British Hydrological Society, no. 142.
}
\examples{
#Get an annual maximum sample and estimate the parameters.
AM.27090 <- GetAM(27090)
Kappa3Pars(AM.27090$Flow)
#calculate Lmoments and estimate the parmeters with L1, L2, Lcv, and Lskew
LPars <- as.numeric(Lmoms(AM.27090$Flow))[c(1,2,5,6)]
Kappa3Pars(L1 = LPars[1], LCV = LPars[2], LSKEW = LPars[3])
}
\author{
Anthony Hammond
}
