% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RainAPI.R
\name{GetFlowStage_EA}
\alias{GetFlowStage_EA}
\title{Get flow or level data from the Environment Agency's Hydrology Data Explorer}
\usage{
GetFlowStage_EA(
  Lat = 54,
  Lon = -2.25,
  Range = 10,
  RiverName = NULL,
  WISKI_ID = NULL,
  From = "2015-10-01",
  To = "2016-09-30",
  Type = "flow",
  Period = "DailyMean"
)
}
\arguments{
\item{Lat}{Latitude (as a decimal) for the centre of the search for gauges}

\item{Lon}{Longitude (as a decimal) for the centre of the search for gauges}

\item{Range}{Radius of search when using latitude and longitude inputs (km).}

\item{RiverName}{Name of the river along which you want to search for gauges. Character string.}

\item{WISKI_ID}{The WISKI ID for the gauge from which you want to obtain data (character string)}

\item{From}{Date for start of data extraction in the format of "2015-12-02"}

\item{To}{Date for the end of data extraction in the format of "2015-12-02"}

\item{Type}{The variable to extract, either "flow" or "level"}

\item{Period}{The sampling rate of the data you want. Either "DailyMax", "DailyMean", "Houlry", "15Mins".}
}
\value{
If searching for gauge details with lat and lon or river name, then a list is returned. The first element is a dataframe with flow gauge details and the second is a dataframe of level gauge details.
When extracting flow or level data with a WISKI ID then a dataframe with two columns is returned. The first being a Date or POSIXct column/vector and the second is the timeseries of interest.
}
\description{
Function to extract flow or level data from the Environment Agency's Hydrology Data Explorer.
}
\details{
To find gauges you can input either a river name or a latitude and longitude. The latter will provide all flow and level gauges within a specified range (default of 10km). This provides gauged details including the WISKI ID. You can get data from specific gauges using the WISKI_ID. Note that many level gauges also have level data available.
}
\examples{
#Find gauges on the river Tame
\dontrun{GetFlowStage_EA(RiverName = "Tame")}
#Find gauges within 10km of a latlon grid reference somewhere near the centre of Dartmoor
\dontrun{GetFlowStage_EA(lat = 50.6, lon = -3.9, Range = 10)}
#Get daily maximum flow data from the Bellever gauge on the
#East Dart River for the default From - To date range
\dontrun{BelleverMax <- GetFlowStage_EA(WISKI_ID = "SX67F051")}
}
\author{
Anthony Hammond
}
