% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unbmom2.R
\name{uM2M3pool}
\alias{uM2M3pool}
\title{Pooled central moment estimates - two-sample}
\usage{
uM2M3pool(m2, m3, m5, n_x, n_y)
}
\arguments{
\item{m2}{naive biased variance estimate \eqn{m_2 = 1/(n_x + n_y) \sum_{i =
1}^{n_x} ((X_i - \bar{X})^2 + \sum_{i = 1}^{n_y} ((Y_i - \bar{Y})^2}{m[2] =
mean(c((X - X-bar)^2, (Y - Y-bar)^2))} for vectors \code{X} and \code{Y}.}

\item{m3}{naive biased third central moment estimate \eqn{m_3 = 1/(n_x + n_y)
\sum_{i = 1}^{n_x} ((X_i - \bar{X})^3 + \sum_{i = 1}^{n_y} ((Y_i -
\bar{Y})^3}{m[3] = mean(c((X - X-bar)^3, (Y - Y-bar)^3))} for vectors
\code{X} and \code{Y}.}

\item{m5}{naive biased fifth central moment estimate \eqn{m_5 = 1/(n_x + n_y)
\sum_{i = 1}^{n_x} ((X_i - \bar{X})^5 + \sum_{i = 1}^{n_y} ((Y_i -
\bar{Y})^5}{m[5] = mean(c((X - X-bar)^5, (Y - Y-bar)^5))} for vectors
\code{X} and \code{Y}.}

\item{n_x}{number of observations in the first group.}

\item{n_y}{number of observations in the second group.}
}
\value{
Pooled estimate of a product of second and third central moments
  \eqn{\mu_2 \mu_3}{\mu[2] \mu[3]}, where \eqn{\mu_2}{\mu[2]} and
  \eqn{\mu_3}{\mu[3]} are second and third central moments respectively.
}
\description{
Calculate pooled unbiased estimates of central moments and their powers and
products.
}
\examples{
nx <- 10
ny <- 8
shp <- 3
smpx <- rgamma(nx, shape = shp) - shp
smpy <- rgamma(ny, shape = shp)
mx <- mean(smpx)
my <- mean(smpy)
m  <- numeric(5)
for (j in 2:5) {
  m[j] <- mean(c((smpx - mx)^j, (smpy - my)^j))
}
uM2M3pool(m[2], m[3], m[5], nx, ny)
}
\seealso{
Other pooled estimates (two-sample): \code{\link{uM2M4pool}},
  \code{\link{uM2pool}}, \code{\link{uM2pow2pool}},
  \code{\link{uM2pow3pool}}, \code{\link{uM3pool}},
  \code{\link{uM3pow2pool}}, \code{\link{uM4pool}},
  \code{\link{uM5pool}}, \code{\link{uM6pool}}
}
\concept{pooled estimates (two-sample)}
