% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tabla_General.R
\name{Tabla.General}
\alias{Tabla.General}
\title{Cree fácilmente un widget para visualización de tablas HTML usando el paquete \code{DT}}
\usage{
Tabla.General(
  datos,
  colNames,
  filtros = FALSE,
  colFilters,
  encabezado = "",
  leyenda = "",
  tituloPdf = NULL,
  mensajePdf = "",
  ajustarNiveles = TRUE,
  scrollX = TRUE,
  colorHead = "#FFFFFF",
  estilo
)
}
\arguments{
\item{datos}{Un data frame o una matriz.}

\item{colNames}{Vector de caracteres que especifica los nombres de las columnas
de la tabla a retornar. Si no se introduce algún valor se tomará el mismo
nombre de las columnas presentes en \code{datos}.}

\item{filtros}{Si es \code{FALSE} (\emph{valor predeterminado}) no se habilitará/aplicará
los filtros por columna. Establézcalo en \code{TRUE} si desea generar filtros de
columna automáticamente.}

\item{colFilters}{Vector numérico que especifica las columnas a las cuales les
desea agregar la opción de poder filtrar. Si no se introduce algún valor todas
las columnas tendrán habilitada la opción de poder filtrar.}

\item{encabezado}{Igual uso que en \code{\link[=Tabla]{Tabla()}}}

\item{leyenda}{Igual uso que en \code{\link[=Tabla]{Tabla()}}}

\item{tituloPdf}{Igual uso que en \code{\link[=Tabla]{Tabla()}}}

\item{mensajePdf}{Igual uso que en \code{\link[=Tabla]{Tabla()}}}

\item{ajustarNiveles}{Igual uso que en \code{\link[=Tabla]{Tabla()}}}

\item{scrollX}{Igual uso que en \code{\link[=Tabla]{Tabla()}}}

\item{colorHead}{Igual uso que en \code{\link[=Tabla]{Tabla()}}}

\item{estilo}{Una lista compuesta por listas las cuales en su interior contiene
argumentos válidos de la función \link[DT:formatCurrency]{formatStyle()}, esto
con la finalidad de que pueda aplicar estilos CSS a la tabla, tales como color
de la fuente, color de fondo, tamaño de fuente, etc. Puede encontrar mayor
información de los argumentos disponibles \href{https://rstudio.github.io/DT/functions.html}{aquí}.}
}
\value{
Retorna la tabla creada mediante \code{DT} la cual pertenece a la clase "datatables"
y "htmlwidget".
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Esta función simplifica la producción de tablas para presentaciones visualmente
atractivas, pues está diseñada para facilitar la creación de tablas para informes
y publicaciones produciendo un widget HTML para visualizar un data frame utilizando
el paquete \code{DT}.
}
\details{
Esta función se basa enteramente del paquete \code{DT}, el cual proporciona una interfaz
para \code{R} a la biblioteca \code{DataTables} de \code{JavaScript}. Los data frames de \code{R}
se pueden mostrar como tablas en páginas HTML, proporcionando opciones de
filtrado, paginación, clasificación y muchas otras características en las tablas.

Al establecer \code{filtros = FALSE} no elimina ni modifica el filtro global
(\emph{cuadro de búsqueda en la parte superior derecha}).

Para el argumento \code{colFilters} recuerde que la numeración inicia en 0, es decir,
la primera columna tiene asociado el índice 0, la segunda el 1, y así sucesivamente.
}
\examples{
\dontshow{if (require("datasets")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
Tabla.General(datos = datasets::mtcars)
\dontshow{\}) # examplesIf}
\dontshow{if (all(require("dplyr"), require("tidyr"), require("DT"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# library("dplyr"); library("tidyr"); library("DT")
df <- ejGraduados |>
  filter(TIPO_NIVEL == "Pregrado") |>
  group_by(YEAR, SEMESTRE, DEP_NAC, CIU_NAC, SEXO, CAT_EDAD, ESTRATO, PROGRAMA) |>
  summarise(Total = n(), .groups = "drop") |>
  mutate(across(where(is.character), \(x) replace_na(x, replace = "SIN INFO")))

Nombres <- c("<em>A\u00f1o</em>", "Semestre", "Departamento",
             "Municipio", "Sexo", "Edad", "Estrato", "Carrera", "Total"
             )
Titulo  <- paste(
  "<b>HIST\u00d3RICO DEL TOTAL DE GRADUADOS DE PREGRADO ",
  "DEPENDIENDO DE LAS VARIABLES SELECCIONADAS</b>"
)
Tabla.General(
  datos          = df,
  colNames       = Nombres,
  filtros        = TRUE,
  colFilters     = 0:3,
  encabezado     = Titulo,
  leyenda        = "N\u00famero de graduados de pregrado por lugar de procedencia.",
  tituloPdf      = "Este es un t\u00edtulo provisional para el PDF",
  mensajePdf     = "Este es un mensaje provisional para el PDF",
  ajustarNiveles = TRUE,
  colorHead      = "#4CFF49",
  estilo         = list(
    list(
      columns = "YEAR", target = "cell", fontWeight = "bold",
      backgroundColor = styleEqual(unique(df$YEAR), c("#FF6400", "#01CDFE", "#FF0532"))
    ),
    list(
      columns = "SEMESTRE", target = "cell", fontWeight = "bold",
      color = styleEqual(unique(df$SEMESTRE), c("#3D3397", "#AE0421"))
    ),
    list(columns = "DEP_NAC", color = "#FFFFFF", backgroundColor = "#4D1B7B"),
    list(columns = "CIU_NAC", color = "#FFFFFF", backgroundColor = "#F59E11")
  )
)
\dontshow{\}) # examplesIf}
}
