## devtools::use_data(tostbegg2)

#' Hepatic metastasis ultrasound study - Tosteson & Begg study (96 patients)
#'
#' \itemize{ \item type primary cancer type: 0 Colon 1 Breast \item d hepatatic
#' metastasis (0 no 1 yes). Non-cancer patients are controls. \item y rating 1
#' to 5: 5 definite metastatic disease to the liver; 4 probable metastatic
#' disease to the liver; 3 possible metastatic disease to the liver; 2 probably
#' normal; and 1 definitely normal. }
#' @name tostbegg2
#' @docType data
#' @details A liver metastasis is a malignant tumor in the liver that has spread
#'   from another organ that has been affected by cancer.
#' @references Tosteson AN, & CB Begg (1988). A general regression methodology
#'   for ROC curve estimation. Medical Decision Making 8, 204-215
#'   \url{https://research.fhcrc.org/diagnostic-biomarkers-center/en/datasets.html}
#'    \url{http://journals.sagepub.com/doi/abs/10.1177/0272989X8800800309}
#' @keywords data
NULL
