% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_BSS_SGL.R
\name{plot_matrix}
\alias{plot_matrix}
\title{Plot the AR coefficient matrix}
\usage{
plot_matrix(phi, p)
}
\arguments{
\item{phi}{parameter matrix}

\item{p}{number of segements times number of lags}
}
\value{
a plot of AR coefficient matrix
}
\description{
Plot the AR coefficient matrix
}
\examples{
nob <- (10^3*4); #number of time points
p <- 15; # number of time series components
brk <- c(floor(nob/3),floor(2*nob/3),nob+1); # true break points with nob+1 as the last element
m0 <- length(brk) -1; # number of break points
q.t <- 2; # the true AR order
m <- m0+1 #number of segments
sp_density <- rep(0.05, m*q.t) #sparsity level (5\%)
try<-simu_var("sparse",nob=nob,k=p,lags=q.t,brk =brk,sp_pattern="random",sp_density=sp_density)
print(plot_matrix(do.call("cbind",try$model_param), m*q.t ))

}
