% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_BSS_SGL.R
\name{simu_tbss}
\alias{simu_tbss}
\title{Simulation function for TBSS algorithm}
\usage{
simu_tbss(
  nreps,
  simu_method = c("sparse", "group sparse", "fLS"),
  nob,
  k,
  lags = 1,
  lags_vector = NULL,
  brk,
  sigma,
  skip = 50,
  group_mats = NULL,
  group_type = c("columnwise", "rowwise"),
  group_index = NULL,
  sparse_mats = NULL,
  sp_density = NULL,
  signals = NULL,
  rank = NULL,
  info_ratio = NULL,
  sp_pattern = c("off-diagonal", "diagoanl", "random"),
  singular_vals = NULL,
  spectral_radius = 0.9,
  est_method = c("sparse", "group sparse", "fLS"),
  q = 1,
  tol = 0.01,
  lambda.1.cv = NULL,
  lambda.2.cv = NULL,
  mu = NULL,
  group.index = NULL,
  group.case = c("columnwise", "rowwise"),
  max.iteration = 100,
  refit = FALSE,
  block.size = NULL,
  blocks = NULL,
  use.BIC = TRUE,
  an.grid = NULL
)
}
\arguments{
\item{nreps}{A numeric integer number, indicates the number of simulation replications}

\item{simu_method}{the structure of time series: "sparse","group sparse", and "fLS"}

\item{nob}{sample size}

\item{k}{dimension of transition matrix}

\item{lags}{lags of VAR time series. Default is 1.}

\item{lags_vector}{a vector of lags of VAR time series for each segment}

\item{brk}{a vector of break points with (nob+1) as the last element}

\item{sigma}{the variance matrix for error term}

\item{skip}{an argument to control the leading data points to obtain a stationary time series}

\item{group_mats}{transition matrix for group sparse case}

\item{group_type}{type for group lasso: "columnwise", "rowwise". Default is "columnwise".}

\item{group_index}{group index for group lasso.}

\item{sparse_mats}{transition matrix for sparse case}

\item{sp_density}{if we choose random pattern, we should provide the sparsity density for each segment}

\item{signals}{manually setting signal for each segment (including sign)}

\item{rank}{if we choose method is low rank plus sparse, we need to provide the ranks for each segment}

\item{info_ratio}{the information ratio leverages the signal strength from low rank and sparse components}

\item{sp_pattern}{a choice of the pattern of sparse component: diagonal, 1-off diagonal, random, custom}

\item{singular_vals}{singular values for the low rank components}

\item{spectral_radius}{to ensure the time series is piecewise stationary.}

\item{est_method}{method: sparse, group sparse, and fixed low rank plus sparse. Default is sparse}

\item{q}{the AR order}

\item{tol}{tolerance for the fused lasso}

\item{lambda.1.cv}{tuning parameter lambda_1 for fused lasso}

\item{lambda.2.cv}{tuning parameter lambda_2 for fused lasso}

\item{mu}{tuning parameter for low rank component, only available when method is set to "fLS"}

\item{group.index}{group index for group sparse case}

\item{group.case}{group sparse pattern: column, row.}

\item{max.iteration}{max number of iteration for the fused lasso}

\item{refit}{logical; if TRUE, refit the VAR model for parameter estimation. Default is FALSE.}

\item{block.size}{the block size}

\item{blocks}{the blocks}

\item{use.BIC}{use BIC for k-means part}

\item{an.grid}{a vector of an for grid searching}
}
\value{
A S3 object of class, named \code{VARDetect.simu.result}
\describe{
    \item{est_cps}{A list of estimated change points, including all replications}
    \item{est_sparse_mats}{A list of estimated sparse components for all replications}
    \item{est_lowrank_mats}{A list of estimated low rank components for all replications}
    \item{est_phi_mats}{A list of estimated model parameters, transition matrices for VAR model}
    \item{running_times}{A numeric vector, containing all running times}
}
}
\description{
Function for deploying simulation using TBSS algorithm
}
\examples{
\donttest{
nob <- 4000; p <- 15
brk <- c(floor(nob / 3), floor(2 * nob / 3), nob + 1)
m <- length(brk); q.t <- 1
sp_density <- rep(0.05, m * q.t)
signals <- c(-0.6, 0.6, -0.6)
try_simu <- simu_tbss(nreps = 3, simu_method = "sparse", nob = nob, 
                      k = p, lags = q.t, brk = brk, sigma = diag(p), 
                      signals = signals, sp_density = sp_density, 
                      sp_pattern = "random", est_method = "sparse", q = q.t, 
                      refit = TRUE)
}
}
