% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkGraphs.R
\name{loadDemoGraph}
\alias{loadDemoGraph}
\title{Load package demonstration network graph}
\usage{
loadDemoGraph(fname)
}
\arguments{
\item{fname}{Character string. Name of demonstration \code{graphml} file.}
}
\value{
An igraph graph object.
}
\description{
This function loads a demonstration network graph included in the \code{extdata} directory of the 
\code{VOSONDash} package by file name.
}
\examples{
\dontrun{
# load the "DividedTheyBlog" demonstration network graph
g_demo_div <- loadDemoGraph("DividedTheyBlog_40Alist_release.graphml")

# load the "enviroActivistWebsites" demonstration network graph
g_demo_env <- loadDemoGraph("enviroActivistWebsites_2006.graphml")
}

}
