% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.VSURF.R
\name{predict.VSURF}
\alias{predict.VSURF}
\title{Predict method for VSURF object}
\usage{
\method{predict}{VSURF}(object, newdata, step = c("interp", "pred"), ...)
}
\arguments{
\item{object}{An object of class \code{VSURF}, which is the result of the
\code{\link{VSURF}} function.}

\item{newdata}{A data frame or matrix containing new data.
(Note: If not given, the out-of-bag predictions of the randomForest object is returned.)}

\item{step}{A character string indicating which variable set must be used to train
the \code{randomForest} object (default is c("interp", "pred")).
Available choices are "thres", "interp", "pred".}

\item{\dots}{further parameters passed to \code{\link{randomForest}} or
\code{\link{predict.randomForest}} functions (depending on their names).}
}
\value{
If only one step is indicated in \code{step}, a vector of predicted values.

If two or more steps are indicated in \code{step}, a data frame of predicted values
(each column corresponding to a variable set).
}
\description{
This function predicts new data with random forests, using variables selected by VSURF only.
}
\details{
This method applies for a VSURF object. VSURF selects two sets of variables during its two
last steps. For each set of variables, a random forest object is created, by running
\code{\link{randomForest}} on training data using this set of variables only. Then the
\code{\link{predict.randomForest}} function is used to predict new data.
}
\examples{

\dontrun{
data(iris)
iris.learn <- sample(1:nrow(iris), nrow(iris)/2)
iris.vsurf <- VSURF(iris[iris.learn, 1:4], iris[iris.learn, 5], ntree = 100, nfor.thres = 20,
                    nfor.interp = 10, nfor.pred = 10)
iris.predictions <- predict(iris.vsurf, newdata = iris[-iris.learn, 1:4])

# A more interesting example with toys data (see \\code{\\link{toys}})
# (a few minutes to execute)
data(toys)
toys.learn <- 1:(nrow(toys$x) / 2)
toys.vsurf <- VSURF(toys$x[toys.learn, ], toys$y[toys.learn])
toys.predictions <- predict(toys.vsurf, newdata = toys$x[-toys.learn, ])}

}
\author{
Robin Genuer, Jean-Michel Poggi and Christine Tuleau-Malot
}
\references{
Genuer, R. and Poggi, J.M. and Tuleau-Malot, C. (2010),
\emph{Variable selection using random forests}, Pattern Recognition Letters
31(14), 2225-2236

Genuer, R. and Poggi, J.M. and Tuleau-Malot, C. (2015),
\emph{VSURF: An R Package for Variable Selection Using Random Forests},
The R Journal 7(2):19-33
}
\seealso{
\code{\link{VSURF}}
}

