% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting.R
\name{prep_data}
\alias{prep_data}
\title{Check the classes of specific columns and re-assigns as necessary.}
\usage{
prep_data(data = data, Subject = Subject, Item = NA,
  EventColumns = c("Subject", "TRIAL_INDEX"))
}
\arguments{
\item{data}{A data frame object created from an Eyelink Sample Report.}

\item{Subject}{An obligatory string containing the column name corresponding to the subject identifier.}

\item{Item}{An optional string containing the column name corresponding to the item identifier; by default, NA.}

\item{EventColumns}{A vector specifying the columns which will be used for creating 
the Event variable; by default, Subject and TRIAL_INDEX.}
}
\value{
An object of type data table as described in \link[dplyr]{tbl_df}.
}
\description{
\code{prep_data} converts the data frame to a data table and examines the 
required columns (RECORDING_SESSION_LABEL, LEFT_INTEREST_AREA_ID, 
RIGHT_INTEREST_AREA_ID, LEFT_INTEREST_AREA_LABEL, RIGHT_INTEREST_AREA_LABEL, 
TIMESTAMP, and TRIAL_INDEX) and optional columns (SAMPLE_MESSAGE, LEFT_GAZE_X,
LEFT_GAZE_Y, RIGHT_GAZE_X, and RIGHT_GAZE_Y). It renames the subject and item 
columns, ensures required/optional columns are of the approriate data class, 
and creates a new column called Event which indexes each unique 
series of samples corresponding to the combination of Subject and 
TRIAL_INDEX (can be changed), necessary for performing subsequent operations.
}
\examples{
\dontrun{
# Typical DataViewer output contains a column called "RECORDING_SESSION_LABEL"
# corresponding to the subject.
# To prepare the data...
library(VWPre)
df <- prep_data(data = dat, Subject = "RECORDING_SESSION_LABEL", Item = "ItemCol")
}
}

