\name{vgFitStart}
\alias{vgFitStart}
\alias{vgFitStartMoM}

\title{Find Starting Values for Fitting a Variance Gamma Distribution}
\description{
  Finds starting values for input to a maximum likelihood routine for
  fitting variance gamma distribution to data.
}

\usage{
  vgFitStart(x, breaks = NULL, startValues = "SL", paramStart = NULL,
             startMethodSL = "Nelder-Mead",
             startMethodMoM = "Nelder-Mead", ...)
  vgFitStartMoM(x, startMethodMoM = "Nelder-Mead", \dots)
}

\arguments{
  \item{x}{Data vector.}
  \item{breaks}{Breaks for histogram. If missing, defaults to those
    generated by
    \code{hist(x, right = FALSE, plot = FALSE)}.}
  \item{startValues}{Vector of the different starting values to consider.
    See \bold{Details}.}
  \item{paramStart}{Starting values for param if
    \code{startValues = "US"}.}
  \item{startMethodSL}{Method used by call to \code{\link{optim}} in
    finding skew Laplace estimates.}
  \item{startMethodMoM}{Method used by call to \code{\link{optim}} in
    finding method of moments estimates.}
  \item{\dots}{Passes arguments to \code{\link{optim}}.}
}

\details{
  Possible values of the argument \code{startValues} are the following:
  \itemize{
    \item{\code{"US"}}{User-supplied.}
    \item{\code{"SL"}}{Based on a fitted skew-Laplace distribution.}
    \item{\code{"MoM"}}{Method of moments.}
  }
  If \code{startValues = "US"} then a value must be supplied for
  \code{paramStart}.

  If \code{startValues = "MoM"}, \code{vgFitStartMoM} is
  called. These starting values are based on Barndorff-Nielsen \emph{et
  al} (1985).

  If \code{startValues = "SL"}, or \code{startValues = "MoM"} an initial
  optimisation is needed to find the starting values. These
  optimisations call \code{\link{optim}}.
}


\value{
  \code{vgFitStart} returns a list with components:
    \item{vgStart}{A vector with elements \code{vgC}, \code{lSigma} (log
      of sigma),  \code{theta} and \code{lNu} (log of nu) giving the
      starting value of param.}
    \item{xName}{A character string with the actual \code{x} argument name.}
    \item{breaks}{The cell boundaries found by a call to
      \code{\link{hist}}.}
    \item{midpoints}{The cell midpoints found by a call to
      \code{\link{hist}}.}
    \item{empDens}{The estimated density found by a call to
      \code{\link{hist}}.}

  \code{vgFitStartMoM} returns only the method of moments estimates
  as a vector with elements \code{vgC}, \code{lSigma} (log of sigma),
  \code{theta} and \code{lNu} (log of nu).
}

\references{
  Seneta, E. (2004). Fitting the variance-gamma model to financial data.
  \emph{J. Appl. Prob.}, 41A:177--187.
}


\author{David Scott \email{d.scott@auckland.ac.nz}, Christine Yang Dong}


\seealso{
  \code{\link{dvg}}, \code{\link[HyperbolicDist]{dskewlap}},
  \code{\link{vgFit}}, \code{\link{hist}}, and
  \code{\link{optim}}.
}

\examples{
param <- c(0,0.5,0,0.5)
dataVector <- rvg(500, param = param)
vgFitStart(dataVector,startValues="SL")
vgFitStartMoM(dataVector)
vgFitStart(dataVector,startValues="MoM")
}