% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_surf3d.R
\name{plot_surf3d}
\alias{plot_surf3d}
\title{3D Surface plotter}
\usage{
plot_surf3d(
  surf_data,
  surf_color = "grey",
  cmap,
  limits,
  atlas = 1,
  hemi = "b",
  medial_gap = 0,
  orientation_labels = TRUE,
  VWR_check = TRUE
)
}
\arguments{
\item{surf_data}{A numeric vector (length of V)}

\item{surf_color}{color of the cortical surface. Set to \code{'grey'} by default}

\item{cmap}{A string vector containing 2 to 4 color names/codes specifying the colors to be used for the color scale. If none are specified, appropriate colors will be automatically selected according to \code{range(surf_data)}}

\item{limits}{A combined pair of numeric vector composed of the lower and upper color scale limits of the plot. When left unspecified, the symmetrical limits \verb{c(-max(abs(surf_dat),max(abs(surf_dat)))} will be used.}

\item{atlas}{atlas used for identifying region labels. 1=Desikan, 2=Destrieux-148, 3=Glasser-360, 4=Schaefer-100, 5=Schaefer-200, 6=Schaefer-400. Set to \code{1} by default. This argument is ignored for hippocampal surfaces.}

\item{hemi}{A string specifying the hemisphere to plot. Possible values are \code{l} (left), \code{r} (right) or \code{b} (both).}

\item{medial_gap}{A numeric value specifying the amount of gap (in MNI coordinate units) to separate the left and right hemispheres. Set to \code{0} (no gap between hemispheres) by default. In order to view the medial surfaces clearly, it is recommended that this value is set to \code{20}. This argument is ignored if \code{hemi!='b'}}

\item{orientation_labels}{A boolean object specifying if orientation labels are to be displayed. Set to \code{TRUE} by default}

\item{VWR_check}{A boolean object specifying whether to check and validate system requirements. Default is TRUE.}
}
\value{
a plot_ly object
}
\description{
Plots 3D cortical surfaces
}
\examples{
surf_data = runif(20484);
plot_surf3d(surf_data = surf_data, VWR_check=FALSE)
}
