% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decode_surf_data.R
\name{decode_surf_data}
\alias{decode_surf_data}
\title{Decode surface data}
\usage{
decode_surf_data(surf_data, contrast = "positive", VWR_check = TRUE)
}
\arguments{
\item{surf_data}{A numeric vector or object containing the surface data, in fsaverage5 (1 x 20484 vertices) or fsLR32k (1 x 64984 vertices) space. It can only be one row of vertices (not a cohort surface data matrix).}

\item{contrast}{A string object indicating whether to decode the positive or negative mask ('positive' or 'negative')}

\item{VWR_check}{A boolean object specifying whether to check and validate system requirements. Default is TRUE.}
}
\value{
A data.frame object listing the keywords and their Pearson's R values
}
\description{
Correlates the significant clusters of an earlier vertex-wise analysis with a database of task-based fMRI and voxel-based morphometric statistical maps and associate them with relevant key words. Decoding currently works with surfaces in fsaverage5 space only."
}
\details{
The \href{https://nimare.readthedocs.io/en/stable/index.html}{'NiMARE'} python module is used for the imaging decoding and is imported via the reticulate package. The function also downloads the \href{https://github.com/neurosynth/neurosynth-data}{'Neurosynth' database} in the package's inst/extdata directory (~8 Mb) for the analysis.
}
\examples{
CTv = rbinom(20484, 1, 0.001) 
decoding = decode_surf_data(CTv, 'positive', VWR_check=FALSE);
head(decoding)
}
