% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_plot.R
\name{plot.visitation_forecast}
\alias{plot.visitation_forecast}
\title{visitation_forecast Plot Methods}
\usage{
\method{plot}{visitation_forecast}(x, type = c("fitted"), difference = FALSE, ...)
}
\arguments{
\item{x}{An object of class "decomposition".}

\item{type}{A character string. One of "full","period", or "classical". If "full", the full reconstruction is plotted. If "period", the reconstruction of each period is plotted individually. If "classical", the trend and seasonality are plotted.}

\item{difference}{A Boolean specifying whether to plot the original fit or differenced series. The default option is FALSE, in which case, the series is not differenced.}

\item{...}{Additional arguments.}
}
\value{
No return value, called for plotting objects of the class "visitation_forecast".
}
\description{
Methods for plotting objects of the class "visitation_forecast".
}
\examples{
#' #Example:

data("park_visitation")
data("flickr_userdays")

n_ahead <- 12
park <- "YELL"
pud_ts <- ts(park_visitation[park_visitation$park == park,]$pud, start = 2005, freq = 12)
pud_ts <- log(pud_ts)
trend_proxy <- log(flickr_userdays)

mf <- visitation_model(pud_ts,trend_proxy)
vf <- predict(mf,12, only_new = TRUE)
plot(vf)
}
