% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simon_oc.R
\name{Simon_oc}
\alias{Simon_oc}
\title{Operating Characteristics of Simon's Two-Stage Design}
\usage{
Simon_oc(
  prob,
  simon,
  type = c("minimax", "optimal", "n1", "maximax"),
  R = 10000L,
  n1 = stop("must provide `n1`"),
  n = stop("must provide `n`"),
  r1 = stop("must provide `r1`"),
  r = stop("must provide `r`"),
  ...
)
}
\arguments{
\item{prob}{\emph{named} \link[base]{numeric} \link[base]{vector},
true response rate(s) of (multiple) drug(s).
The \code{names(prob)} should be the respective keyword(s) for the drug(s).}

\item{simon}{\link[clinfun]{ph2simon} object}

\item{type}{\link[base]{character} scalar, type of Simon's two-stage design.
Currently supports
\code{'minimax'} (default) for minimum total sample size,
\code{'optimal'} for minimum expected total sample size \emph{under \eqn{p_0}},
\code{'n1'} for minimum Stage-1 sample size \eqn{n_1},
\code{'maximax'} to use up the user-provided maximum total sample size
(parameter \code{nmax} of \link[clinfun]{ph2simon})}

\item{R}{\link[base]{integer} scalar, number of simulations.  Default \code{1e4L}.}

\item{n1, n}{(optional) \link[base]{integer} scalars, Stage-1 sample size \eqn{n_1}
and total sample size \eqn{n}.  Will be overridden if \code{simon} is given}

\item{r1, r}{(optional) \link[base]{integer} scalars, number of response
in Stage-1 \eqn{r_1} and overall \eqn{r} required \emph{exclusively}.
In other words, passing Stage-1 means observing \eqn{>r_1} response.
Will be overridden if \code{simon} is given}

\item{...}{potential parameters, currently not in use}
}
\value{
\link{Simon_oc} returns \linkS4class{Simon_oc} object
}
\description{
Operating characteristics of Simon's two-stage design.
}
\details{
..
}
\examples{
library(clinfun)
(x = ph2simon(pu = .2, pa = .4, ep1 = .05, ep2 = .1)) 
Simon_oc(prob = c(A = .3, B = .2, C = .15), simon = x, type = 'minimax', R = 1e3L)
Simon_oc(prob = c(A = .3, B = .2, C = .15), simon = x, type = 'optimal', R = 1e3L)

}
\references{
\doi{10.1016/0197-2456(89)90015-9}
}
