% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_f.R
\name{modify_event}
\alias{modify_event}
\title{Modify the time of existing events}
\usage{
modify_event(evt, create_if_null = TRUE)
}
\arguments{
\item{evt}{A list of events and their times}

\item{create_if_null}{A boolean.
If TRUE, it will create non-existing events with the chosen time to event.
If FALSE, it will ignore those.}
}
\value{
No return value, modifies/adds event to \code{cur_evtlist} and integrates it with the main list for storage
}
\description{
Modify the time of existing events
}
\details{
The functions to add/modify events/inputs use lists. Whenever several inputs/events are added or modified, it's recommended to group them within one function, as it reduces the computation cost.
So rather than use two \code{modify_event} with a list of one element, it's better to group them into a single \code{modify_event} with a list of two elements.

This function does not evaluate sequentially.

This function is intended to be used only within the \code{add_reactevt} function in its \code{input} parameter and should not be run elsewhere or it will return an error.
}
\examples{
add_reactevt(name_evt = "idfs",input = {modify_event(list("os"=5))})
}
