% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{pwreg}
\alias{pwreg}
\title{Fit priority-adjusted proportional win-fractions (PW) regression model}
\usage{
pwreg(time, status, Z, ID, rho = 0, eps = 1e-04, maxiter = 50)
}
\arguments{
\item{time}{a vector of all the event times.}

\item{status}{a vector of the status for all the event. 0: censoring, 1:death
and 2: non-fatal event.}

\item{Z}{a matrix or a vector of covariates.}

\item{ID}{a vector of unique subject-level identifiers.}

\item{rho}{a non-negative number as the power of the survival function used
in the weight. Default (\code{rho=0}) is recommended.}

\item{eps}{precision for the convergence of Newton-Raphson algorithm.}

\item{maxiter}{maximum number of iterations allowe for the Newton-Raphson
algorithm.}
}
\value{
An object of class \code{pwreg} with the following components.
\code{beta}:a vector of estimated regression coefficients. \code{Var}:estimated
covariance matrix for \code{beta}. \code{conv:} boolean variable indicating
whether the algorithm converged within the maximum number of iterations.
}
\description{
Fit priority-adjusted proportional win-fractions (PW) regression model.
}
\examples{
library(WR)
head(non_ischemic)
id_unique <-unique(non_ischemic$ID)

# Randomly sample 200 subjects from non_ischemic data
set.seed(2019)
id_sample <- sample(id_unique, 200)
non_ischemic_reduce <- non_ischemic[non_ischemic$ID \%in\% id_sample, ]

# Use the reduced non_ischemic data for analysis
nr <- nrow(non_ischemic_reduce)
p <- ncol(non_ischemic_reduce)-3
ID <- non_ischemic_reduce[,"ID"]
time <- non_ischemic_reduce[,"time"]
status <- non_ischemic_reduce[,"status"]
Z <- as.matrix(non_ischemic_reduce[,4:(3+p)],nr,p)
pwreg.obj <- pwreg(time=time,status=status,Z=Z,ID=ID)
print(pwreg.obj)
}
\references{
Mao, L. and Wang, T. (2020+). "A class of proportional win-fractions
regression models for composite outcomes". Under review.
}
\seealso{
\code{\link{score.proc}}
}
