% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lnres_err.R
\name{lnres_err}
\alias{lnres_err}
\title{Simulate random errors from a time series}
\usage{
lnres_err(dat_in, yr = NULL, comps = FALSE, seed = NULL)
}
\arguments{
\item{dat_in}{input \code{\link[base]{data.frame}} that must include discharge and decimal time columns, see example dataset \code{\link{daydat}}}

\item{yr}{numeric year value to use for the stationary model, defaults to the median year}

\item{comps}{logical indicating ifthe WRTDS model used to get response error measures is also returned, see value.}

\item{seed}{optional numeric value for random generation seed}
}
\value{
The original data frame with additional columns for the random errors (\code{errs}) and the standard error estimates for each residual (\code{scls}).  If \code{comps = TRUE}, a two-element list is returned that also includes the WRTDS model used as a basis for errors and scale values.
}
\description{
Simulate random errors of a water quality time series by modelling the statistical properties of an observed dataset
}
\details{
Random errors for a stationary seasonal water quality time series on a daily time step are generated by modelling residuals from an observed dataset.  First, a stationary seasonal model is created by fitting a \code{\link{wrtds}} model and estimating an error distribution the residuals using the \code{\link[forecast]{auto.arima}} function.  Accumulated standard errors from the regression are also retained for each residual.  Random errors using the estimated auto-regressive structures are simulated using \code{\link[stats]{arima.sim}} for the entire year and multiplied by the corresponding standard error estimate from the regression.  The entire year is then repeated for every year in the observed time series.  The final simulated errors are rescaled to the range of the original residuals that were used to estimate the distribution.
}
\examples{
\dontrun{
## example data
data(daydat)

## get errors
lnres_err(daydat)
}
}
\seealso{
\code{\link{daydat}}
}

