% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistributionPlot.R
\name{PlotDistCountNormal}
\alias{PlotDistCountNormal}
\title{plot distribution details as a histogram plus matching normal}
\usage{
PlotDistCountNormal(frm, xvar, title, ..., binWidth = c())
}
\arguments{
\item{frm}{data frame to get values from}

\item{xvar}{name of the independent (input or model) column in frame}

\item{title}{title to place on plot}

\item{...}{no unarmed argument, added to force named binding of later arguments.}

\item{binWidth}{with of histogram bins}
}
\description{
assumes that xvar is a factor variable
sort < 0 sorts the factor levels in decreasing order (most frequent level first)
sort > 0 sorts the factor levels in increasing order (good when used in conjunction with coord_flip())
sort = 0 leaves the factor levels in "natural order" -- usually alphabetical
stem = FALSE will plot only the dots, without the stem to the y=0 line.
limit_n = NULL plots all the levels, N an integer limits to the top N most populous levels
}
\examples{

set.seed(52523)
d <- data.frame(wt=100*rnorm(100))
PlotDistCountNormal(d,'wt','example')

}
